;;#################################################
;; toolbar.lsp 
;; code to implement toolbar for workmap
;; Copyright (c) 1992-2002 by Forrest W. Young
;;#################################################
(setf *toolbox* nil)

(defun show-toolbar (&optional (w *workmap*) (tb *toolbar*))
  (let ((num-buts-see-max  (send w :num-toolbar-buts))
        (num-buts (send tb :num-icons))
        (dc (send w :draw-color))
        (bc (send w :back-color))
        )
    (send tb :change-num-tools-shown 
          (if num-buts-see-max (min num-buts num-buts-see-max) num-buts))
    (send w :show-toolbar)
    (send w :back-color bc)
    (send w :draw-color dc)))

(defun hide-toolbar (&optional (w *workmap*) (tb *toolbar*))
  (send w :hide-toolbar))

(defun toolbox (&optional (w *workmap*))
  (let* ((num-buts-see-max  (send w :num-toolbar-buts))
         (overlay (send toolbox-overlay-proto :new w))
         (tool-names *initial-button-names*)
         (num-buts (length tool-names))
         (analysis-symbols *initial-analysis-symbols*))
    (setf tb overlay)
    (send w :add-overlay tb)
    (send w :toolbar-obj tb)
    (mapcar #'(lambda (tool i) 
                (let ((tool-objid 
                       (send overlay :add-tool-icon (+ (* i 52) 10) 5 tool)))
                  (send tool-objid :analysis (select analysis-symbols i))))
            tool-names (iseq num-buts))
    (send tb :num-icons-shown 
          (if num-buts-see-max (min num-buts num-buts-see-max) num-buts))
    (send tb :num-icons num-buts)
    (send tb :button-name-list  tool-names)
    (send tb :button-name-master tool-names)
;do not update next list with soft buttons
    (send tb :hard-button-name-list tool-names)
    (send tb :icon-list-master (send tb :icon-list))
    (send tb :show-tools)
    (send tb :redraw)
    overlay))

(defproto toolbox-overlay-proto 
  '(num-icons icon-list analysis-symbol-list button-name-list data-types-list
              three-buttons x y selected-icon extended-icon-list w
              num-icons-shown data-types-master analysis-symbols-master
              enable-soft-buttons soft-button-titles hard-button-name-list
              button-name-master icon-list-master analyze-menu-item-name-master
              )  
   () graph-overlay-proto)

(defmeth toolbox-overlay-proto :isnew (w)
  (call-next-method)
  (send self :w w)
  (send self :num-icons 0))

(defmeth toolbox-overlay-proto :num-icons (&optional (val nil set))
  (if set (setf (slot-value 'num-icons) val))
  (slot-value 'num-icons))

(defmeth toolbox-overlay-proto :num-icons-shown (&optional (val nil set))
  (if set (setf (slot-value 'num-icons-shown) val))
  (slot-value 'num-icons-shown))

(defmeth toolbox-overlay-proto :icon-list (&optional (val nil set))
"List of objids of icons showing on toolbar"
  (if set (setf (slot-value 'icon-list) val))
  (slot-value 'icon-list))

(defmeth toolbox-overlay-proto :analysis-symbol-list (&optional (val nil set))
"List of objids of icons showing on toolbar"
  (if set (setf (slot-value 'analysis-symbol-list) val))
  (slot-value 'analysis-symbol-list))

(defmeth toolbox-overlay-proto :extended-icon-list (&optional (val nil set))
"List of all toolbar button icon objids for visible and hidden icons."
  (if set (setf (slot-value 'extended-icon-list) val))
  (slot-value 'extended-icon-list))

(defmeth toolbox-overlay-proto :hard-button-name-list (&optional (val nil set))
"List of hard-wired original 7 toolbar button names."
  (if set (setf (slot-value 'hard-button-name-list) val))
  (slot-value 'hard-button-name-list))

(defmeth toolbox-overlay-proto :data-types-list (&optional (val nil set))
"List of data types of all button data types that appear on the toolbar"
  (if set (setf (slot-value 'data-types-list) val))
  (slot-value 'data-types-list))

(defmeth toolbox-overlay-proto :ok-data-types (&optional (val nil set))
"List of data types of all button data types that appear on the toolbar"
  (if set (setf (slot-value 'data-types-list) val))
  (slot-value 'data-types-list))

(defmeth toolbox-overlay-proto :data-types-master (&optional (val nil set))
"List of data types of all buttons that can appear on the toolbar"
  (if set (setf (slot-value 'data-types-master) val))
  (slot-value 'data-types-master))

(defmeth toolbox-overlay-proto :analyze-menu-item-name-master (&optional (val nil set))
"List of analysis symbols of all buttons that can appear on the toolbar."
  (if set (setf (slot-value 'analyze-menu-item-name-master) val))
  (slot-value 'analyze-menu-item-name-master))

(defmeth toolbox-overlay-proto :analysis-symbols-master (&optional (val nil set))
"List of analysis symbols of all buttons that can appear on the toolbar."
  (if set (setf (slot-value 'analysis-symbols-master) val))
  (slot-value 'analysis-symbols-master))

(defmeth toolbox-overlay-proto :button-name-master (&optional (val nil set))
"List of names of all buttons mastering on the toolbar"
  (if set (setf (slot-value 'button-name-master) val))
  (slot-value 'button-name-master))

(defmeth toolbox-overlay-proto :button-name-list (&optional (val nil set))
"List of names of all buttons that could be on the toolbar"
  (if set (setf (slot-value 'button-name-list) val))
  (slot-value 'button-name-list))

(defmeth toolbox-overlay-proto :soft-button-titles (&optional (val nil set))
"List of names of buttons on the toolbar"
  (if set (setf (slot-value 'soft-button-titles) val))
  (slot-value 'soft-button-titles))

(defmeth toolbox-overlay-proto :icon-list-master (&optional (val nil set))
"List of obj-ids of all buttons mastering on the toolbar"
  (if set (setf (slot-value 'icon-list-master) val))
  (slot-value 'icon-list-master))

(defmeth toolbox-overlay-proto :w (&optional (val nil set))
  (if set (setf (slot-value 'w) val))
  (slot-value 'w))

(defmeth toolbox-overlay-proto :x (&optional (val nil set))
  (if set (setf (slot-value 'x) val))
  (slot-value 'x))

(defmeth toolbox-overlay-proto :y (&optional (val nil set))
  (if set (setf (slot-value 'y) val))
  (slot-value 'y))

(defmeth toolbox-overlay-proto :three-buttons (&optional (val nil set))
  (if set (setf (slot-value 'three-buttons) val))
  (slot-value 'three-buttons))

(defmeth toolbox-overlay-proto :selected-icon 
       (&optional (icon-number nil set))
  (if set (setf (slot-value 'selected-icon) icon-number))
  (slot-value 'selected-icon))

(defmeth toolbox-overlay-proto :enable-soft-buttons (&optional (val nil set))
  (if set (setf (slot-value 'enable-soft-buttons) val))
  (slot-value 'enable-soft-buttons))
  
(defmeth toolbox-overlay-proto :initialize-master-lists ()
  (send self :data-types-master 
        (send *vista* :plugin-data-types))
  (send self :data-types-list (send self :data-types-master))
  (send self :analyze-menu-item-name-master 
        (send *vista* :plugin-menu-item-titles)))

(defmeth toolbox-overlay-proto :append-tool (tool-object)
  (let ((num-buts-see-max 
         (min (send self :num-icons-fit-in-window)
              (send (send self :w) :num-toolbar-buts))))
    (send tool-object :x (+ (* (send self :num-icons) 52) 10))
    (send tool-object :y 5)
    (send self :num-icons (+ 1 (send self :num-icons)))
    (send self :num-icons-shown 
          (if num-buts-see-max (min (send self :num-icons) num-buts-see-max) 
              (send self :num-icons)))
    (send self :x (append (send self :x) (list (send tool-object :x))))
    (send self :y (append (send self :y) (list (send tool-object :y))))
    (send self :icon-list (append (send self :icon-list) (list tool-object)))
    (send self :ok-data-types (append (send self :ok-data-types)
                                      (last (send *vista* :plugin-data-types)))) 
    (send self :button-name-list (append (send self :button-name-list)
                                         (list (send tool-object :title))))  
    (send self :icon-list-master (append (send self :icon-list-master) 
                                        (list tool-object)))
    (send self :button-name-master (append (send self :button-name-master) 
                                          (list (send tool-object :title))))
    (send self :analyze-menu-item-name-master 
          (append (send self :analyze-menu-item-name-master)
                  (last (send *vista* :plugin-menu-item-titles))))
    (send self :data-types-master 
          (append (send self :data-types-master)
                  (last (send *vista* :plugin-data-types))))
    (send self :analysis-symbols-master 
         (append (send self :analysis-symbols-master)
                  (last (send *vista* :plugin-menu-item-titles))))
    (send (send self :graph) :redraw)
    ))

(defmeth toolbox-overlay-proto :add-tool-icon (x y title)
  (let ((graph (send self :graph))
        (tool-objid)
        )
    (send self :num-icons (+ 1 (send self :num-icons)))
    (send self :x (append (send self :x) (list x)))
    (send self :y (append (send self :y) (list y)))
    (setf tool-objid 
          (send tool-icon-proto :new graph x y 45 13 :draw t :title title
                :title-separation 1 :title-back-color 'toolbar-background))
    
    (send self :icon-list (append (send self :icon-list)
       (list tool-objid)))
    tool-objid))

(defmeth toolbox-overlay-proto :show-tools ()
  (let ((icli (send self :icon-list)))
    (mapcar #'(lambda (icon) 
                (send icon :draw t)) icli)))

(defmeth toolbox-overlay-proto :update-buttons ()
  (when (send (send self :graph) :gui)
        (let* ((num-fit (send self :num-icons-fit-in-window))
              (num-shown (min num-fit (send self :num-icons-shown)))
              (icon-list  (select (send self :icon-list) (iseq num-shown))))
          (mapcar #'(lambda (icon)
                      (send icon :show-icon 
                            (send icon :state) :draw t))
                  icon-list))))

#|
(defmeth toolbox-overlay-proto :num-icons-fit-in-window ()
  (let* (
         (graph (send self :graph))
         (toolbar-length (send graph :toolbar-length))
         (has-v-scroll (send graph :has-v-scroll))
         (unused-toolbar-space 
                  (- (first (send graph :size)) 
                     toolbar-length 
                     (if has-v-scroll 140 124)))
         (icon-space 56))
    (ceiling (/ (+ toolbar-length unused-toolbar-space) icon-space))))
|#

(defmeth toolbox-overlay-proto :draw-toolbar (&key (show t))
  (let* ((graph (send self :graph))
         (draw-color (send graph :draw-color))
         (back-color (send graph :back-color))
         (toolbar-length (send graph :toolbar-length))
         (has-v-scroll (send graph :has-v-scroll))
         (freeze-toolbar nil)
         (num-fit (send self :num-icons-fit-in-window))
         (logo-at-top)
         (n    (send self :num-icons))
         (num-shown (send self :num-icons-shown))
         (dummy (WHEN (< (SEND SELF :NUM-ICONS-SHOWN) 1)
                      (WHEN *VERBOSE* (PRINT "IN TOOLBAR.LSP DRAW-TOOLBAR: NO BUTTONS"))
                      (HIDE-TOOLBAR)(SHOW-TOOLBAR)))
         (DUMMY (when (> (first (send graph :size)) 
                         (+ toolbar-length (if has-v-scroll 140 124)))
                      (setf logo-at-top nil)))
         )
    (when (and (send graph :toolbar)
              ; (> (send self :num-icons-shown) 0)
              ; (not (send (send self :graph) :postpone-redraw))
               );*workmap*
          (let* ((text-h (+ (send graph :text-ascent) 
                            (send graph :text-descent)))
                 (unused-toolbar-space 
                  (- (first (send graph :size)) 
                     toolbar-length 
                     (if has-v-scroll 140 124)))
                 (icon-space 56)
                 (num-shown 
                  (cond
                    (freeze-toolbar num-shown)
                    ((< unused-toolbar-space 0)
                     (ceiling (/ (+ toolbar-length unused-toolbar-space) icon-space)))
                    (t num-shown)))
                 (num-shown (max 3 (min num-shown (send self :num-icons-shown))))
                 (toolbar-length
                  (cond
                    (freeze-toolbar toolbar-length)
                    (t (- toolbar-length 
                          (* icon-space (- (send self :num-icons-shown)
                                           num-shown))))))
                 (logo-at-top (> (first (send graph :size)) 
                                 (+ toolbar-length (if has-v-scroll 140 124))))
                 
                 (unused-toolbar-space (- (first (send graph :size)) toolbar-length))
                 (icon-space 56)
                 (toolbar-length
                  (ceiling (/ (+ toolbar-length unused-toolbar-space) 
                                    icon-space)))
                 (logo-at-top nil)
                 (icon-list (select (send self :icon-list)
                                    (if (< num-shown 3) 3 (iseq num-shown))))
                       (x    (select (send self :x) (iseq num-shown)))
                 (y    (send self :y))
                       (scroll (send graph :scroll))
                 (scrollx (+ 90 (first scroll)));100
                 (scrolly (second scroll))
                       (icon nil)   
                 (bar-bottom (+ 20 text-h));32
                 (right-end (+ (first (last x)) 56))
                 (far-right-end right-end)
                 (vrx (first  (send graph :view-rect)))
                 (vry (second (send graph :view-rect)))
                 (w (third  (send graph :view-rect)))
                 (h (fourth (send graph :view-rect)))
                 (logo-width 125)
                 #+macintosh       (u 1)
                 #-macintosh       (u 0)
                 )
            (if (send *vista* :background-color)
                (send graph :draw-color 'toolbar-background)
                (send graph :draw-color 'white))
            (send graph :paint-rect 
                  (+ scrollx 2) (- scrolly u)
                  (- far-right-end 8) (+ bar-bottom 2))
            (send graph :back-color 'workmap-background);toolbar-background
            (send graph :draw-color 'tool-icon-color)
            (when (send graph :gui)
                  (mapcar #'(lambda (icon x y) 
                              (send icon :x (+ x scrollx))
                              (send icon :y (+ y -1 scrolly))
                              (send icon :show-icon 
                                          (send icon :state) :draw show))
                          icon-list x y))
            (send graph :draw-color 'black)
            
            (send graph :frame-rect
                  (+ scrollx 2) (- scrolly u) 
                  (- right-end 4) (+ bar-bottom 2))
            (send graph :frame-rect
                  (+ scrollx 4) (- (+ scrolly 2) u)
                  (- right-end 8) (- bar-bottom 2))
            ;next clause was commented out
            (when logo-at-top
                  (send graph :frame-rect
                        (+ scrollx 2) (- scrolly u) 
                        (- far-right-end 4) (+ bar-bottom 2))
                  (send graph :frame-rect
                        (+ scrollx right-end -1) (- (+ scrolly 2) u)
                        (- 130 8) (- bar-bottom 2)) )
            (send graph :draw-color 'toolbar-background)
            (send graph :paint-rect (+ scrollx right-end -2) scrolly w (+ 4 text-h))
            (send graph :line-width 2)
            (send graph :draw-color 'black)
            (send graph :draw-line (+ scrollx right-end -2) scrolly (+ vrx w) scrolly )
            (send graph :draw-line (+ scrollx right-end -2) (+ text-h scrolly 4) 
                  (+ vrx w) (+ text-h scrolly 4))
            (send graph :line-width 1)
            (send self :three-buttons 
                  (send self :draw-three-buttons)) 
            ))
    (send graph :back-color back-color)
    (send graph :draw-color draw-color)
    ))

(defmeth toolbox-overlay-proto :draw-buttons ()
  (let* ((graph (send self :graph))
         (num-fit (send self :num-icons-fit-in-window))
         (num-shown (min num-fit (send self :num-icons-shown)))
         (icon-list (select (send self :icon-list)) (iseq num-fit))
         (scroll (send graph :scroll))
         (scrollx (+ 90 (first scroll)));100
         (scrolly (second scroll))
         (x (select (+ (send self :x) scrollx)) (iseq num-fit))
         (y (select (+ (send self :y) scrolly)) (iseq num-fit))
         )
    (when (send graph :gui)
          (mapcar #'(lambda (icon x y) 
                      (send icon :x x)
                      (send icon :y (1- y))
                      (send icon :show-icon (send icon :state)))
                  icon-list x y)
          )))

(defmeth toolbox-overlay-proto :draw-three-buttons ()
  (when (not  (send (send self :graph) :postpone-redraw))
        (when (send (send self :graph) :toolbar)
              (let* ((graph (send self :graph))
                     (draw-color (send graph :draw-color))
                     (back-color (send graph :back-color))
                     (icon (select (send graph :icon-list) 
                                   (send graph :selected-icon)))
                    ; (n 3)
                     (text-h (+ (send graph :text-ascent) 
                             (send graph :text-descent)))
                     (scroll (send graph :scroll))
                     (scrollx (first scroll))
                     (scrolly (second scroll))
                     (bar-bottom (+ 20 text-h));32
                     (right-end 40)
                     (h (send graph :canvas-height))
                     (w (send graph :canvas-width))
                     (r1 35);40
                     (r2 20);20
#+macintosh          (u 1)
#-macintosh          (u 0)
                     (3buts (send self :three-buttons))
                     (icon)(help-button)(stats-button)(graph-button))
                (cond 
                  (3buts
                   (setf help-button (first 3buts))
                   (setf stats-button (second 3buts))
                   (setf graph-button (third 3buts))
                   )
                  (t
                   (setf help-button (make-button graph 'help19 
                         (+ scrollx 11) (+ scrolly 7)));10
                   (setf stats-button (make-button graph 'stats19 
                         (+ scrollx 44) (+ scrolly 7)));50
                   (setf graph-button (make-button graph 'graph19
                         (+ scrollx 67) (+ scrolly 7)));70
                    ))
                (if (send *vista* :background-color)
                    (send graph :draw-color 'toolbar-background)
                    (send graph :draw-color 'white))
                (send graph :paint-rect 
                      (+ scrollx 2) (- scrolly u)
                      (- right-end 4) (+ bar-bottom 2))
                (send graph :paint-rect 
                      (+ scrollx 2 r1) (- scrolly u)
                      (+ (- right-end 4) r2) (+ bar-bottom 2))
                (send help-button :draw-color 'red)
                (send help-button :x (+ scrollx 11));10
                (send help-button :y (+ scrolly 7))
                (send stats-button :x (+ scrollx 44));50
                (send stats-button :y (+ scrolly 7))
                (send graph-button :x (+ scrollx 67));70
                (send graph-button :y (+ scrolly 7))
                (send help-button :draw)
                (send stats-button :draw)
                (send graph-button :draw)
                (send graph :draw-color 'black)
                (send graph :frame-rect
                      (+ scrollx 2) (- scrolly u) 
                      (- right-end 4) (+ bar-bottom 2))
                (send graph :frame-rect
                      (+ scrollx 4) (- (+ scrolly 2) u)
                      (- right-end 8) (- bar-bottom 2))
                (send graph :frame-rect
                      (+ scrollx 2 r1) (- scrolly u)
                      (+ (- right-end 4) r2) (+ bar-bottom 2))
                (send graph :frame-rect
                      (+ scrollx 4 r1) (- (+ scrolly 2) u)
                      (+ (- right-end 8) r2) (- bar-bottom 2))
                (when (send *vista* :background-color)
                      (send graph :back-color back-color))
                (list help-button stats-button graph-button)
                ))))

(defmeth toolbox-overlay-proto :intercept-click ())

(defmeth toolbox-overlay-proto :do-click (x y m1 m2)
  (when (send (send self :graph) :toolbar)
        (let* ((graph (send self :graph))
               (n (send self :num-icons-shown))
               (icon-list (send self :icon-list)) ;icon-list
               (three-buttons (send self :three-buttons))
               (stat-obj-icon (select (send graph :icon-list)
                                      (send graph :selected-icon)))
               (th (+ (send graph :text-ascent) (send graph :text-descent)))
               (but)
               (iconx (send self :x))
               (icony (send self :y))
               (scroll (send graph :scroll))
               (scrollx (first scroll))
               (scrolly (second scroll))
               (toolbar-length (send graph :toolbar-length))
               (ix nil)
               (iy nil)
               (ifl nil)
               ) 
          (when (and (< y (+ scrolly 32)) (< x (+ toolbar-length scrollx)))
                (send self :intercept-click)
                (dotimes (i 3)
                 (setf ix (send (select three-buttons i) :x))
                 (setf iy (send (select three-buttons i) :y))
                 (when (and (< ix x (+ ix 19)) (< iy y (+ iy 19)))
                       (setf but (select three-buttons i))
                       (when (not (equal (send but :draw-color) 'never-shown-color))
                             (send but :state "hilited")
                             (send but :draw)
                             (case i 
                               (0 (vista-help))
                               (1 (send *current-object* :summarize :dialog t))
                               (2 (send *current-object* :visualize-statistical-object :dialog t)))
                             (send but :state "normal")
                             (send but :draw))))
                (unless but
                 (dotimes (i n)
                  (setf ix (+ scrollx 80 (select iconx i)))
                  (setf iy (+ scrolly (select icony i)))
                  (when (and (< ix x (+ ix 45)) (< iy y (+ iy 13)))
                        (send self :selected-icon i)
                        (setf ifl t)
                        (if (and (send self :enable-soft-buttons) m2)
                            (send self :change-button-function i)
                            (let* ((icon (select icon-list i))
                                   (state (send icon :icon-state))
                                   )
                              (when (equal "normal" state)
                                    (send icon :icon-state "hilited")
                                    (send icon :show-icon "selected")
                                    (send (eval (send icon :analysis)) :do-action))
                              ))
                        (return)))
                  (unless ifl (when m2 ;(print "HI");(toolbar-options)
                                    (send *toolbar-popup-menu* :popup-menu x y graph))))
                ))))


    
(defmeth toolbox-overlay-proto :set-three-buttons ()
  )

(defmeth toolbox-overlay-proto :set-two-buttons (stats? graph?)
  (let* (
         (3but (send self :three-buttons))
         (sbut)
         (gbut) 
         )
    (when (not 3but)
          (setf 3but (send self :draw-three-buttons)))
    (when 3but
          (setf sbut (second 3but))
          (setf gbut (third 3but))
          (cond
            (stats?
             (send sbut :state "normal")
             (send sbut :draw-color 'tool-icon-color))
            (t
             (send sbut :state "gray")
             (send sbut :draw-color 'never-shown-color)))
          (send sbut :draw)
          (cond
            (graph?
             (send gbut :state "normal")
             (send gbut :draw-color 'tool-icon-color))
            (t
             (send gbut :state "gray")
             (send gbut :draw-color 'never-shown-color)))
          (send gbut :draw))))

(defmeth toolbox-overlay-proto :make-new-tool (tool-title)
  (let* ((graph (send self :graph))
         (new-tool (send tool-icon-proto 
                         :new graph 0 0 45 13 :draw nil 
                         :title tool-title :title-separation 1 
                         :title-back-color 'toolbar-background))
         (eil (send self :extended-icon-list)))
    (when (not eil) 
          (setf eil (send self :icon-list)))
    (setf eil (combine eil new-tool))
    (send self :extended-icon-list eil)                                   
    (1- (length eil))))

;next method returns objid of original icon, not of new one.
;i changed it despite fear of breaking who-knows-what.
;fwy july 2002 

(defmeth toolbox-overlay-proto :copy-tool-icon (tool-number &optional name)
  (let* ((graph (send self :graph))
         (fixit (send graph :selected-icon 
                      (send graph :selected-data-icon)))
         (out-number (send graph :selected-icon))
         (toolbar-tool)
         (workmap-icon)
         (title)
         )
    (when (not (send self :num-icons-shown))
          (send self :num-icons-shown 
                (length (send self :icon-list))))
    (cond 
      ((= -1 tool-number)
       (setf title (if name name (send current-transf :model-abbrev))))
      ((< -1 tool-number (send self :num-icons-shown))
       (setf toolbar-tool (select (send self :icon-list) tool-number))
       (setf title (if name name (send toolbar-tool :title))) )
      (t 
       (setf toolbar-tool (select (send self :extended-icon-list) tool-number))
       (setf title (if name name (send toolbar-tool :title)))))

    (setf workmap-icon 
          (send graph :add-connected-icon out-number title 2 
                (send current-object :determine-data-type)
                :object current-object))
    (when (< -1 tool-number (send self :num-icons-shown))
          (send toolbar-tool :icon-state "normal")
          (send toolbar-tool :show-icon "normal" :draw t)
          )
    workmap-icon))

(defmeth toolbox-overlay-proto :tool-number (tool-name)
  (let* ((icon-list (send self :icon-list))
         (title-list
          (mapcar #'(lambda (icon) (string-downcase (send icon :title)))
                  icon-list)))
    (position (string-downcase tool-name) title-list :test #'equal)))

(defmeth toolbox-overlay-proto :reset-button (button)
  (let* ((but-num (send self :tool-number button))
         (icon (if but-num (select (send self :icon-list) but-num))))
    (when but-num
          (send icon :icon-state "normal")
          (send icon :show-icon "normal" :draw t))))

(defmeth toolbox-overlay-proto :items ()
  (send self :icon-list))
